using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgInvalidateSpecimen
	/// </summary>
	public class DlgInvalidateSpecimen : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Data.DataTable _dtComments;
		private bool _detailsRequired = false;
		private Guid _cannedCommentGuid;

		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Label dd;
		private System.Windows.Forms.Label lblWarningMessage;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.PictureBox picWarning;
		private System.Windows.Forms.Label lblMessage1;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgInvalidateSpecimen()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgInvalidateSpecimen));
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpComment = new System.Windows.Forms.GroupBox();
			this.lblMessage1 = new System.Windows.Forms.Label();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dd = new System.Windows.Forms.Label();
			this.lblWarningMessage = new System.Windows.Forms.Label();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.grpIcon = new System.Windows.Forms.GroupBox();
			this.picWarning = new System.Windows.Forms.PictureBox();
			this.grpComment.SuspendLayout();
			this.grpIcon.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(378, 30);
			this.vbecsLogo1.TabIndex = 3;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 231);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(296, 216);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(216, 216);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			// 
			// grpComment
			// 
			this.grpComment.AccessibleDescription = "All test results for the specimen were invalidated. To mark the specimen as unacc" +
				"eptable, enter a comment and click OK.                                          " +
				"                  Click Cancel to leave the specimen unchanged.";
			this.grpComment.AccessibleName = "All test results for the specimen were invalidated. To mark the specimen as unacc" +
				"eptable, enter a comment and click OK.                                          " +
				"                  Click Cancel to leave the specimen unchanged.";
			this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComment.Controls.Add(this.lblMessage1);
			this.grpComment.Controls.Add(this.cmbComment);
			this.grpComment.Controls.Add(this.dd);
			this.grpComment.Controls.Add(this.lblWarningMessage);
			this.grpComment.Controls.Add(this.txtComment);
			this.grpComment.Controls.Add(this.lblDetails);
			this.grpComment.Location = new System.Drawing.Point(64, 36);
			this.grpComment.Name = "grpComment";
			this.grpComment.Size = new System.Drawing.Size(308, 176);
			this.grpComment.TabIndex = 0;
			this.grpComment.TabStop = false;
			// 
			// lblMessage1
			// 
			this.lblMessage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblMessage1.Location = new System.Drawing.Point(8, 12);
			this.lblMessage1.Name = "lblMessage1";
			this.lblMessage1.Size = new System.Drawing.Size(292, 20);
			this.lblMessage1.TabIndex = 0;
			this.lblMessage1.Text = "All test results for the specimen were invalidated.";
			this.lblMessage1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "comment";
			this.cmbComment.AccessibleName = "comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 100;
			this.cmbComment.Location = new System.Drawing.Point(68, 88);
			this.cmbComment.MaxLength = 80;
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(224, 22);
			this.cmbComment.TabIndex = 3;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// dd
			// 
			this.dd.Location = new System.Drawing.Point(8, 88);
			this.dd.Name = "dd";
			this.dd.Size = new System.Drawing.Size(60, 20);
			this.dd.TabIndex = 2;
			this.dd.Text = "Comment*";
			this.dd.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblWarningMessage
			// 
			this.lblWarningMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblWarningMessage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblWarningMessage.Location = new System.Drawing.Point(8, 36);
			this.lblWarningMessage.Name = "lblWarningMessage";
			this.lblWarningMessage.Size = new System.Drawing.Size(288, 40);
			this.lblWarningMessage.TabIndex = 1;
			this.lblWarningMessage.Text = "To mark the specimen as unacceptable, enter a comment and click OK.              " +
				"                                              Click Cancel to leave the specimen" +
				" unchanged.";
			this.lblWarningMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtComment
			// 
			this.txtComment.AccessibleDescription = "details";
			this.txtComment.AccessibleName = "details";
			this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComment.Location = new System.Drawing.Point(68, 112);
			this.txtComment.MaxLength = 255;
			this.txtComment.Multiline = true;
			this.txtComment.Name = "txtComment";
			this.txtComment.Size = new System.Drawing.Size(224, 56);
			this.txtComment.TabIndex = 5;
			this.txtComment.Text = "";
			this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 112);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(60, 20);
			this.lblDetails.TabIndex = 4;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpIcon
			// 
			this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpIcon.Controls.Add(this.picWarning);
			this.grpIcon.Location = new System.Drawing.Point(4, 36);
			this.grpIcon.Name = "grpIcon";
			this.grpIcon.Size = new System.Drawing.Size(56, 176);
			this.grpIcon.TabIndex = 4;
			this.grpIcon.TabStop = false;
			// 
			// picWarning
			// 
			this.picWarning.Image = ((System.Drawing.Image)(resources.GetObject("picWarning.Image")));
			this.picWarning.Location = new System.Drawing.Point(4, 12);
			this.picWarning.Name = "picWarning";
			this.picWarning.Size = new System.Drawing.Size(45, 45);
			this.picWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picWarning.TabIndex = 0;
			this.picWarning.TabStop = false;
			// 
			// DlgInvalidateSpecimen
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(378, 247);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpComment);
			this.Controls.Add(this.grpIcon);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Invalidate_Test_Results.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(384, 272);
			this.Name = "DlgInvalidateSpecimen";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Invalidate Specimen";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgInvalidateSpecimen_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpIcon, 0);
			this.Controls.SetChildIndex(this.grpComment, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpComment.ResumeLayout(false);
			this.grpIcon.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC094.DlgInvalidateSpecimen());
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.CommentRequired().ResString);
			//
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.LoadComments("SU");
		}

		/// <summary>
		/// Returns the comments from the Comment combo box appended to any text in the 
		/// Details test box
		/// </summary>
		public string Comment
		{
			get
			{
				string comment = "";
				if (this.cmbComment.SelectedIndex>-1)
				{
					if (this.cmbComment.Text.Trim().ToUpper() != "OTHER")
					{
						comment	= this.cmbComment.Text;
					}
					if (this.txtComment.Text.Trim().Length>0)
					{
						if ((comment.Length>0) && (comment[comment.Length-1] != '.'))
						{
							comment = comment + ". ";
						}
						comment = comment + this.txtComment.Text;
					}
				}
				return comment;
			}
		}

		/// <summary>
		/// Returns the Canned Comment Guid
		/// </summary>
		public Guid CannedCommentGuid
		{
			get
			{
				return _cannedCommentGuid;
			}
			
		}
		/// <summary>
		/// Returns text from the Details text bo
		/// </summary>
		public string Details
		{
			get
			{
				return this.txtComment.Text;
			}
		}

		/// <summary>
		/// LoadComments
		/// </summary>
		/// <param name="cannedCommentContext"></param>
		public void LoadComments(string cannedCommentContext)
		{
			_dtComments = BOL.CannedComment.GetCannedComments(cannedCommentContext);
			//
			foreach(System.Data.DataRow drComment in _dtComments.Rows)
			{
				this.cmbComment.Items.Add(drComment[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
		}

		private void CheckValid()
		{
			if (_detailsRequired)
			{
				btnOK.EnabledButton = (this.txtComment.Text.Trim().Length>0);
			}
			else
			{
				btnOK.EnabledButton = (this.cmbComment.SelectedIndex>-1);
			}
			//
			if (btnOK.EnabledButton) 
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				if (_detailsRequired)
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString);
				}
				else
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.CommentRequired().ResString);
				}
			}

		}

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.CheckIfDetailsRequired();
			//
			this.CheckValid();
			System.Data.DataRow [] dtArray = null;
			if (_dtComments != null)
			{
                // CR2814: Add an escape character so queries with single quotes don't crash.
                dtArray = _dtComments.Select(Common.VbecsTables.CannedComment.CannedCommentText + " = '" + cmbComment.Text.Replace("'", "''") + "'");
			}

			if (dtArray != null && dtArray.Length > 0) this._cannedCommentGuid  = (Guid) dtArray[0][Common.VbecsTables.CannedComment.CannedCommentGuid];
		}

		private void CheckIfDetailsRequired()
		{
			//Details required if Comment = Other
			if (this.cmbComment.Text.Trim().ToUpper() == "OTHER")
			{
				this.lblDetails.Text = "Details*";
				this._detailsRequired = true;
			}
			else
			{
				this.lblDetails.Text = "Details";
				this._detailsRequired = false;
			}
		}

		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			this.CheckValid();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgInvalidateSpecimen_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.btnOK.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );	
		}

	

	}
}

